import 'package:admin_desktop/application/main/main_provider.dart';
import 'package:admin_desktop/presentation/routes/app_router.dart';
import 'package:auto_route/auto_route.dart';
import 'package:flutter/material.dart';
import 'package:remixicon_updated/remixicon_updated.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:admin_desktop/presentation/styles/style.dart';
import 'package:admin_desktop/infrastructure/services/utils.dart';
import 'package:admin_desktop/presentation/components/components.dart';
import '../../../app_assets.dart';
import 'components/pin_button.dart';
import 'components/pin_container.dart';
import 'package:admin_desktop/application/pin_code/pin_code_provider.dart';

@RoutePage()
class PinCodePage extends ConsumerStatefulWidget {
  final bool isNewPassword;

  const PinCodePage(this.isNewPassword, {super.key});

  @override
  ConsumerState<PinCodePage> createState() => _PinCodePageState();
}

class _PinCodePageState extends ConsumerState<PinCodePage> {
  @override
  void initState() {
    WidgetsBinding.instance.addPostFrameCallback((s) {
      ref.read(mainProvider.notifier).fetchMyShop();
    });
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    final notifier = ref.read(pinCodeProvider.notifier);
    final state = ref.watch(pinCodeProvider);
    final shop = ref.watch(mainProvider);
    return Scaffold(
      body: SizedBox(
        width: MediaQuery.sizeOf(context).width,
        child: Row(
          children: [
            Container(
              constraints: BoxConstraints(maxWidth: 536.r),
              child: SafeArea(
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    24.verticalSpace,
                    if (AppHelpers.getUserRole != TrKeys.master)
                      Row(
                        children: [
                          36.horizontalSpace,
                          CommonImage(
                            url: shop.shop?.logoImg,
                            height: 48,
                          ),
                          4.horizontalSpace,
                          Text(
                            shop.shop?.translation?.title ?? "",
                            style: Style.interNormal(size: 14),
                          )
                        ],
                      ),
                    Spacer(),
                    Center(
                      child: Column(
                        children: [
                          36.verticalSpace,
                          Text(
                            AppHelpers.getTranslation(widget.isNewPassword
                                ? TrKeys.enterNewPinCode
                                : state.isPinCodeNotValid == false
                                    ? TrKeys.enterPinCode
                                    : TrKeys.enterPinCodeError),
                            style: Style.interMedium(
                              color: state.isPinCodeNotValid == false
                                  ? Style.black
                                  : Style.red,
                              size: 28,
                            ),
                            textAlign: TextAlign.center,
                          ),
                          12.verticalSpace,
                          Text(
                            AppHelpers.getTranslation(
                                state.isPinCodeNotValid == false
                                    ? TrKeys.pinCodeDesc
                                    : TrKeys.pinCodeDescError),
                            style: Style.interNormal(
                              color: state.isPinCodeNotValid == false
                                  ? Style.black
                                  : Style.red,
                              size: 16,
                            ),
                            maxLines: 2,
                            textAlign: TextAlign.center,
                          ),
                          24.verticalSpace,
                          SizedBox(
                            height: 28.r,
                            child: ListView.builder(
                                physics: const NeverScrollableScrollPhysics(),
                                itemCount: 4,
                                shrinkWrap: true,
                                scrollDirection: Axis.horizontal,
                                itemBuilder: (context, index) {
                                  return PinContainer(
                                    isActive: state.pinCode.length > index,
                                  );
                                }),
                          ),
                          GridView.builder(
                              padding: EdgeInsets.symmetric(
                                  vertical: 24.r, horizontal: 108.r),
                              physics: const NeverScrollableScrollPhysics(),
                              itemCount: 12,
                              shrinkWrap: true,
                              gridDelegate:
                                  SliverGridDelegateWithFixedCrossAxisCount(
                                crossAxisCount: 3,
                                crossAxisSpacing: 28.r,
                                mainAxisSpacing: 24.r,
                                mainAxisExtent: 72.r,
                              ),
                              itemBuilder: (context, index) {
                                return PinButton(
                                  title: index != 9 && index != 11
                                      ? AppHelpers.getPinCodeText(index)
                                      : null,
                                  iconData: index == 9
                                      ? Remix.close_circle_line
                                      : index == 11
                                          ? Remix.delete_back_2_line
                                          : null,
                                  onTap: () {
                                    if (index == 9) {
                                      notifier.clearPinCode();
                                    } else if (index == 11) {
                                      notifier.removePinCode();
                                    } else {
                                      if (widget.isNewPassword) {
                                        notifier.setNewPinCode(
                                          code:
                                              AppHelpers.getPinCodeText(index),
                                          onSuccess: () {
                                            context.replaceRoute(
                                                const MainRoute());
                                          },
                                        );
                                      } else {
                                        notifier.setPinCode(
                                          code:
                                              AppHelpers.getPinCodeText(index),
                                          onSuccess: () {
                                            context.replaceRoute(
                                                const MainRoute());
                                          },
                                        );
                                      }
                                    }
                                  },
                                );
                              }),
                          24.verticalSpace,
                          Padding(
                            padding: EdgeInsets.symmetric(horizontal: 98.r),
                            child: LoginButton(
                                borderRadius: 15.r,
                                title: AppHelpers.getTranslation(
                                    widget.isNewPassword
                                        ? TrKeys.save
                                        : TrKeys.apply),
                                onPressed: () {
                                  if (widget.isNewPassword) {
                                    notifier.checkNewCode(onSuccess: () {
                                      context.replaceRoute(const MainRoute());
                                    });
                                  } else {
                                    notifier.checkCode(onSuccess: () {
                                      context.replaceRoute(const MainRoute());
                                    });
                                  }
                                }),
                          ),
                          if (!widget.isNewPassword)
                            Column(
                              children: [
                                12.verticalSpace,
                                Padding(
                                  padding:
                                      EdgeInsets.symmetric(horizontal: 98.r),
                                  child: LoginButton(
                                      titleColor: Style.black,
                                      bgColor: Style.transparent,
                                      title: AppHelpers.getTranslation(
                                          TrKeys.logout),
                                      onPressed: () {
                                        context
                                            .replaceRoute(const LoginRoute());
                                        LocalStorage.clearStore();
                                      }),
                                ),
                              ],
                            ),
                        ],
                      ),
                    ),
                    Spacer(),
                  ],
                ),
              ),
            ),
            Expanded(
                child: Image.asset(
              Assets.pngSplash,
              height: double.infinity,
              fit: BoxFit.cover,
            )),
          ],
        ),
      ),
    );
  }
}
